## Where Clause

MDX where clause (aka. slicer).




### Description

The MDX where clause even though sharing the same name as the SQL statement is fundamentally different.

An MDX `WHERE` clause reduces the scope of the query. The `WHERE` clause reduces the cube into a new sliced cube, the slice being defined by the WHERE clause.

<pre>
SELECT
    [Measures].Members ON 0,
    [Geography].[Geo].Members ON 1
FROM [Sales]
WHERE ([Time].[Calendar].[Year].[2010])
</pre>

In the previous query, only that section of the cube where the year is `2010` is used; the rest of the cube is ignored.

Tuples and sets can be used in a `WHERE` clause :

<pre>
SELECT
    ...
WHERE {
    ([Geography].[Geo].[Spain],[Product].[icCube].[Personal]),
    ([Geography].[Geo].[Switzerland],[Product].[icCube].[Corporate])
}
</pre>

See `Where clause on a set of tuples` example below for further explanation.

The where clause does not allow to use a hierarchy being used in one of the axes. SubQueries, which are similar, offer greater flexibility.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Basic - member

</div>

<div class="ic3-mdx-example-body" style="display:none">

The standard example where the where clause is used to overwrite default values.

In our example the value returned is ([Geography].[Geo].[Switzerland],[Measures].[Amount]).

**Query**

```
SELECT
    [Measures].[Amount] ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Switzerland]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>248</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    ( [Geography].[Geo].[Switzerland], [Measures].[Amount] ) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Basic - tuple

</div>

<div class="ic3-mdx-example-body" style="display:none">

The standard example where the where clause is used to overwrite default values.

In our example the value returned is ([Geography].[Geo].[Switzerland], [Product].[Prod].[Personal], [Measures].[Amount]).

**Query**

```
SELECT
    ( [Measures].[Amount] * [Geography].[Economy].members ) ON 0
FROM
    [Sales]
WHERE
    ( [Geography].[Geo].[Switzerland], [Product].[Prod].[Personal] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">ALL</td>
  <td class="ic3-mdx-result-cell-header">None</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>8</td>
 <td>8</td>
 <td>8</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[x] AS ( [Measures].[Amount], [Geography].[Economy].[Switzerland], [Product].[Prod].[Personal] )
SELECT
    [Measures].[x] * Hierarchize( Ascendants( [Geography].[Geo].[Switzerland] )) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where clause applies on hierarchy not on dimensions

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to highlight that the limitation on the where clause applies to hierarchy and not dimensions. Indeed, a dimension used in the slicer may be used as well in one axis.

In the example the where clause is producing the evaluation of the tuple ([Geography].[Geo].[Europe],[Geography].[Economy].[None]).

**Query**

```
WITH
    MEMBER [Measures].[Pol Name] AS [Geography].[Economy].currentMember.Name
SELECT
    {([Geography].[Geo].[Europe],[Measures].[Amount]),
    ([Geography].[Geo].[Europe],[Measures].[Pol Name])} ON 0
FROM
    [Sales]
WHERE
    ([Geography].[Economy].[None])
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Europe</td>
  <td class="ic3-mdx-result-cell-header">Europe</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
  <td class="ic3-mdx-result-cell-header">Pol Name</td>
</tr>
<tr>
 <td>248</td>
 <td>None</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Pol Name] AS [Geography].[Economy].currentMember.Name
SELECT
    {([Geography].[Geo].[Europe],[Geography].[Economy].[None],[Measures].[Amount]),
    ([Geography].[Geo].[Europe],[Geography].[Economy].[None],[Measures].[Pol Name])} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - SUM aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause can be applied to a set of members performing a SUM aggregation.

**Query**

```
SELECT
    {[Measures].[Amount]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>251</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS ([Geography].[Geo].[Spain],[Measures].[Amount])+([Geography].[Geo].[Switzerland],[Measures].[Amount])
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
     MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount]), ([Geography].[Geo].[Switzerland],[Measures].[Amount]) } )
 SELECT
     {[Geography].[Geo].[Spain+Switzerland]} ON 0
 FROM
     [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - COUNT aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause can be applied to a set of members performing a COUNT aggregation.

**Query**

```
SELECT
    {[Measures].[Amount-Count]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-Count</td>
</tr>
<tr>
 <td>7</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Geography].[Geo].[Spain+Switzerland] AS ([Geography].[Geo].[Spain],[Measures].[Amount-Count])+([Geography].[Geo].[Switzerland],[Measures].[Amount-Count])
SELECT
    {[Geography].[Geo].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
     MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-Count]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-Count]) } )
 SELECT
     {[Geography].[Geo].[Spain+Switzerland]} ON 0
 FROM
     [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - MIN aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause can be applied to a set of members performing a MIN aggregation.

**Query**

```
SELECT
    {[Measures].[Amount-Min]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-Min</td>
</tr>
<tr>
 <td>1.00€</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
     MEMBER [Geography].[Geo].[Spain+Switzerland] AS Min( { [Geography].[Geo].[Spain], [Geography].[Geo].[Switzerland] },[Measures].[Amount-Min] )
 SELECT
     {[Geography].[Geo].[Spain+Switzerland]} ON 0
 FROM
     [Sales]
```


**Assertion : Cell Equals**

```
WITH
     MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-Min]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-Min]) } )
 SELECT
     {[Geography].[Geo].[Spain+Switzerland]} ON 0
 FROM
     [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - MAX aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause can be applied to a set of members performing a MAX aggregation.

**Query**

```
SELECT
    {[Measures].[Amount-Max]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-Max</td>
</tr>
<tr>
 <td>128.00€</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
     MEMBER [Geography].[Geo].[Spain+Switzerland] AS Max( { [Geography].[Geo].[Spain], [Geography].[Geo].[Switzerland] },[Measures].[Amount-Max] )
 SELECT
     {[Geography].[Geo].[Spain+Switzerland]} ON 0
 FROM
     [Sales]
```


**Assertion : Cell Equals**

```
WITH
     MEMBER [Geography].[Geo].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-Max]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-Max]) } )
 SELECT
     {[Geography].[Geo].[Spain+Switzerland]} ON 0
 FROM
     [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - AVERAGE (leaves) aggregation

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause can be applied to a set of members performing a AVERAGE (leaves) aggregation.

**Query**

```
SELECT
    {[Measures].[Amount-AvgLeaves]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-AvgLeaves</td>
</tr>
<tr>
 <td>35.857142857142854</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
     MEMBER [Measures].[Spain+Switzerland] AS Aggregate( { ([Geography].[Geo].[Spain],[Measures].[Amount-AvgLeaves]), ([Geography].[Geo].[Switzerland],[Measures].[Amount-AvgLeaves]) } )
 SELECT
     {[Measures].[Spain+Switzerland]} ON 0
 FROM
     [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - DISTINCT COUNT

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause can be applied to a set of members performing a DISTINCT COUNT (leaves) aggregation.

In our example, behaves like count as values are unique.

**Query**

```
SELECT
    {[Measures].[Amount-Unique]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-Unique</td>
</tr>
<tr>
 <td>7</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    {[Measures].[Amount-Count]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - NON EMPTY

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause can be applied to a set of members performing a NON EMPTY (leaves) aggregation.

**Query**

```
SELECT
    {[Measures].[Amount-NoEmpty]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-NoEmpty</td>
</tr>
<tr>
 <td>1</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[True] AS 1
SELECT
    {[Measures].[True]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - AVERAGE (children) aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
SELECT
    {[Measures].[Amount-AvgChildren]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-AvgChildren</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_slicer_aggregate_type_not_supported)<br>Error Message : the aggregation 'average (children)' is not supported in the slicer (aka. where).</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - OPEN aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
SELECT
    {[Measures].[Amount-Open]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-Open</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_slicer_aggregate_type_not_supported)<br>Error Message : the aggregation 'open' is not supported in the slicer (aka. where).</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - CLOSE aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
SELECT
    {[Measures].[Amount-Close]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-Close</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_slicer_aggregate_type_not_supported)<br>Error Message : the aggregation 'close' is not supported in the slicer (aka. where).</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - OPEN (non-empty) aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
SELECT
    {[Measures].[Amount-OpenNoEmpty]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-OpenNoEmpty</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_slicer_aggregate_type_not_supported)<br>Error Message : the aggregation 'open (non-empty)' is not supported in the slicer (aka. where).</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where (member set) - CLOSE (non-empty) aggregation not supported

</div>

<div class="ic3-mdx-example-body" style="display:none">

Not supported.

**Query**

```
SELECT
    {[Measures].[Amount-CloseNoEmpty]} ON 0
FROM
    [Sales]
WHERE
    {[Geography].[Geo].[Spain]}+{[Geography].[Geo].[Switzerland]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount-CloseNoEmpty</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED](icCubeError.md#olap_slicer_aggregate_type_not_supported)<br>Error Message : the aggregation 'close (non-empty)' is not supported in the slicer (aka. where).</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where clause on a set of tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause can be applied also to a set of tuples.

**Query**

```
SELECT
    {[Measures].[Amount]} ON 0
FROM
    [Sales]
WHERE
    {([Geography].[Geo].[Spain],[Product].[icCube].[Personal]),([Geography].[Geo].[Switzerland],[Product].[icCube].[Corporate])}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>147</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Spain+Switzerland] AS
    ([Geography].[Geo].[Spain],[Product].[icCube].[Personal],[Measures].[Amount])+([Geography].[Geo].[Switzerland],[Product].[icCube].[Corporate],[Measures].[Amount])
SELECT
    {[Measures].[Spain+Switzerland]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension filtering (1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

The geography dimension members are being filtered by the slicer content. Here [Canada] is filtered out because of [Spain] defined in the slicer.

**Query**

```
SELECT
    [Geography].[Geo].[Canada] on 0
FROM
    [Sales]
WHERE
    [Geography].[Economy].[Spain]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT {} ON 0 FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension filtering (2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Similar to the previous but note how the [Canada] member is still accessible within axis expression.

**Query**

```
SELECT
    Iif( [Geography].[Geo].[Canada].Parent.Parent.NAME = 'All Regions', ( [Measures].[Fx], [Geography].[Geo].[Spain] ), ( [Measures].[Amount], [Geography].[Geo].[Spain] ) ) on 0
FROM
    [Sales]
WHERE
    [Geography].[Economy].[Spain]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Fx</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Spain</td>
</tr>
<tr>
 <td>1.0310000000000001</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT ( [Measures].[Fx], [Geography].[Economy].[Spain] ) ON 0 FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension filtering : Measures

</div>

<div class="ic3-mdx-example-body" style="display:none">

Similar as previous example showing that the [Measures] dimension is handled the same way.

**Query**

```
SELECT
    Iif( Count( [Measures].members ) = 1, [Time].[Calendar].[2010], [Time].[Calendar].[2011] ) ON 0
FROM
    [Sales]
WHERE
    [Measures].[Amount]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">2010</td>
</tr>
<tr>
 <td>1023</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    [Time].[Calendar].[2010] ON 0
FROM
    [Sales]
WHERE
    [Measures].[Amount]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension filtering : calculated measures (1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calculated measures are ignored from filtering.

**Query**

```
WITH
    MEMBER [Measures].[x] AS 42
SELECT
    Iif( Count( [Measures].[x] ) = 1, [Time].[Calendar].[2010], [Time].[Calendar].[2011] ) ON 0
FROM
    [Sales]
WHERE
    [Measures].[Amount]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">2010</td>
</tr>
<tr>
 <td>1023</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    [Time].[Calendar].[2010] ON 0
FROM
    [Sales]
WHERE
    [Measures].[Amount]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension filtering : calculated measures (2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calculated measures are not filtering anything.

**Query**

```
WITH
    MEMBER [Measures].[x] AS 42
SELECT
    Iif( Count( [Measures].members ) = 14, [Time].[Calendar].[2010], [Time].[Calendar].[2011] ) ON 0
    //                                ^^^^
    //                      we've 14 regular measures (non of them have been filtered out)
FROM
    [Sales]
WHERE
    [Measures].[x]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">2010</td>
</tr>
<tr>
 <td>42</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[x] AS 42
SELECT
    [Time].[Calendar].[2010] ON 0
FROM
    [Sales]
WHERE
    [Measures].[x]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension filtering : calculated members (1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calculated members are ignored from filtering.

**Query**

```
WITH
    MEMBER [Time].[Calendar].[Year].[1900] AS 42
SELECT
    Iif( Count( [Time].[Calendar].[Year].[1900] ) = 1, [Measures].[Amount], [Measures].[Fx] ) ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Year].[2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>1023</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    [Measures].[Amount] ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Year].[2010]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension filtering : calculated members (2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calculated members are not filtering anything.

**Query**

```
WITH
    MEMBER [Time].[Calendar].[Year].[1900] AS 42
SELECT
    Iif( Count( [Time].[Calendar].[Year].members ) = 2, [Measures].[Amount], [Measures].[Fx] ) ON 0
    //                                              ^^^
    //                                    we have 2 regular years (none of them have been filtered out)
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Year].[1900]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>42</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Time].[Calendar].[Year].[1900] AS 42
SELECT
    [Measures].[Amount] ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Year].[1900]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension filtering : calculated members (3)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calculated members are not filtering anything.

**Query**

```
WITH
    MEMBER [Time].[Calendar].[Year].[1900] AS -( [Measures].currentMember, [Time].[Calendar].[Year].[2010] )
SELECT
    Iif( Count( [Time].[Calendar].[Year].members ) = 2, [Measures].[Amount], [Measures].[Fx] ) ON 0
    //                                              ^^^
    //                                    we have 2 regular years (none of them have been filtered out)
FROM
    [Sales]
WHERE
    ( [Time].[Calendar].[Year].[1900], [Geography].[Geo].[Spain] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>-3</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[x] AS -( [Measures].[Amount], [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Spain] )
SELECT
    [Measures].[x] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where clause cannot slice axis hierarchies (1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause cannot use a hierarchy that is used in the axis. SubQueries should be used to overcome this constraint.

Members in calculated members do not have this limitation.

**Query**

```
SELECT
    { ( [Measures].[Amount], [Geography].[Geo].[Switzerland] ) } ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Spain]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_SLICER_AXIS_MULTIPLE_HIERARCHY](icCubeError.md#olap_slicer_axis_multiple_hierarchy)</td></tr><tr><td>Error Message</td><td>

the hierarchy '[Geography].[Geo]' cannot be used both in the slicer and in one axis</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where clause cannot slice axis hierarchies (2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause cannot use a hierarchy that is used in the axis. SubQueries should be used to overcome this constraint.

Members in calculated members do not have this limitation.

**Query**

```
SELECT
    [Geography].[Geo].[Switzerland] ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Spain]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_SLICER_AXIS_MULTIPLE_HIERARCHY](icCubeError.md#olap_slicer_axis_multiple_hierarchy)</td></tr><tr><td>Error Message</td><td>

the hierarchy '[Geography].[Geo]' cannot be used both in the slicer and in one axis</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where clause cannot slice axis hierarchies (3)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A where clause cannot use a hierarchy that is used in the axis. SubQueries should be used to overcome this constraint.

Members in calculated members do not have this limitation.

**Query**

```
SELECT
    [Geography].[Geo].members ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Spain]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_SLICER_AXIS_MULTIPLE_HIERARCHY](icCubeError.md#olap_slicer_axis_multiple_hierarchy)</td></tr><tr><td>Error Message</td><td>

the hierarchy '[Geography].[Geo]' cannot be used both in the slicer and in one axis</td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Empty

</div>

<div class="ic3-mdx-example-body" style="display:none">

Evaluating the slicer to null is making the result empty.

**Query**

```
SELECT
    [Measures].[Amount] ON 0
FROM
    [Sales]
WHERE
    ( [Geography].[Geo].[Spain] , [Geography].[Economy].[France] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_SLICER_NULL_EVAL](icCubeError.md#olap_slicer_null_eval)</td></tr><tr><td>Error Message</td><td>

the slicer cannot be evaluated to a NULL member or an empty set.</td></tr></table>


 
</div>

                                                                         

### See Also


[Where Clause Exists](Where%20Clause%20Exists.md)

[Where Set Clause Exists](Where%20Set%20Clause%20Exists.md)

[SubQueries](SubQueries.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
